/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.model;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.LogWriter;
import noppes.npcs.client.gui.select.GuiTextureSelection;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import org.lwjgl.input.Keyboard;

public class GuiModelColor
extends SubGuiInterface
implements ITextfieldListener {
    private static final ResourceLocation colorGui = new ResourceLocation("moreplayermodels:textures/gui/color_gui.png");
    private static final ResourceLocation colorPicker = new ResourceLocation("moreplayermodels:textures/gui/color.png");
    private ResourceLocation npcSkin;
    private final ColorCallback callback;
    public int color;
    public int colorX;
    public int colorY;
    public int hover;
    public boolean hovered;
    public GuiScreen parent;
    private BufferedImage bufferColor;
    private BufferedImage bufferSkin;
    private GuiNpcTextField textfield;

    public GuiModelColor(GuiScreen parent, int color, ColorCallback callback) {
        this.parent = parent;
        this.callback = callback;
        this.ySize = 230;
        this.closeOnEsc = false;
        this.color = color;
        this.background = colorGui;
        this.npcSkin = null;
        this.hover = 0;
        this.hovered = false;
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton guibutton) {
        if (guibutton.field_146127_k == 66) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.npcSkin != null) {
            this.field_146297_k.func_110434_K().func_110577_a(colorGui);
            int xs = this.colorX + 128;
            int ys = this.colorY;
            this.func_73729_b(xs + 3, ys - 5, 11, 0, 134, 1);
            this.func_73729_b(xs + 2, ys - 4, 10, 1, 135, 1);
            this.func_73729_b(xs + 1, ys - 3, 9, 2, 136, 122);
            this.func_73729_b(xs, ys + 119, 8, 169, 137, 4);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(xs + 4), (float)ys, (float)0.0f);
            GlStateManager.func_179152_a((float)0.46f, (float)0.46f, (float)0.46f);
            this.field_146297_k.func_110434_K().func_110577_a(this.npcSkin);
            Gui.func_73734_a((int)-1, (int)-1, (int)258, (int)258, (int)(GuiTextureSelection.dark ? -2039584 : -14671840));
            Gui.func_73734_a((int)0, (int)0, (int)256, (int)256, (int)(GuiTextureSelection.dark ? -16777216 : -1));
            int g = 16;
            for (int u = 0; u < 16; ++u) {
                for (int v = 0; v < 16; ++v) {
                    if (u % 2 != (v % 2 == 0 ? 1 : 0)) continue;
                    Gui.func_73734_a((int)(u * g), (int)(v * g), (int)(u * g + g), (int)(v * g + g), (int)(GuiTextureSelection.dark ? -13355980 : -3355444));
                }
            }
            this.func_73729_b(0, 0, 0, 0, 256, 256);
            GlStateManager.func_179121_F();
        } else if (this.npc != null && this.bufferSkin == null && !this.npc.display.getSkinTexture().isEmpty()) {
            this.npcSkin = new ResourceLocation(this.npc.display.getSkinTexture());
            InputStream stream = null;
            try {
                IResource resource = this.field_146297_k.func_110442_L().func_110536_a(this.npcSkin);
                stream = resource.func_110527_b();
                this.bufferSkin = ImageIO.read(stream);
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        LogWriter.error(ex);
                    }
                }
            }
        }
        this.hovered = false;
        if (this.bufferColor == null) {
            InputStream stream = null;
            try {
                IResource resource = this.field_146297_k.func_110442_L().func_110536_a(colorPicker);
                stream = resource.func_110527_b();
                this.bufferColor = ImageIO.read(stream);
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        LogWriter.error(ex);
                    }
                }
            }
        }
        int x = this.colorX + 4;
        int y = this.colorY;
        this.func_73733_a(x - 2, y - 2, x + 120, y + 119, -986896, -14671840);
        this.func_73733_a(x - 1, y - 1, x + 119, y + 118, -14671840, -986896);
        this.field_146297_k.func_110434_K().func_110577_a(colorPicker);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(x, y, 0, 1, 120, 120);
        if (this.bufferColor != null && this.isMouseHover(mouseX, mouseY, x, y, 117, 117)) {
            int xb = (mouseX - x) * 4;
            int yb = (mouseY - y + 1) * 4;
            this.hover = this.bufferColor.getRGB(xb, yb) & 0xFFFFFF;
            this.hovered = true;
        } else {
            x = this.colorX + 132;
            if (this.bufferSkin != null && this.isMouseHover(mouseX, mouseY, x, y, 118, 118)) {
                float xb = (float)(mouseX - x) / 0.458823f;
                float yb = (float)(mouseY - y) / 0.458823f;
                float w = 256.0f / (float)this.bufferSkin.getWidth();
                float h = 256.0f / (float)this.bufferSkin.getHeight();
                try {
                    this.hover = this.bufferSkin.getRGB((int)(xb / w), (int)(yb / h)) & 0xFFFFFF;
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
                this.hovered = true;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.colorX + 5), (float)(this.colorY - 25), (float)1.0f);
        int c = this.hovered ? this.hover : this.color;
        this.func_73733_a(-1, -1, 21, 21, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.func_73733_a(0, 0, 20, 20, -16777216 + c, -16777216 + c);
        this.func_73733_a(0, 0, 20, 20, c, c);
        GlStateManager.func_179121_F();
    }

    public String getColor() {
        StringBuilder str = new StringBuilder(Integer.toHexString(this.color));
        while (str.length() < 6) {
            str.insert(0, "0");
        }
        return str.toString();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.colorX = this.guiLeft + 4;
        this.colorY = this.guiTop + 50;
        this.textfield = new GuiNpcTextField(0, this, this.guiLeft + 35, this.guiTop + 25, 60, 20, this.getColor());
        this.textfield.setHoverText("hover.set.color", new Object[0]);
        this.addTextField(this.textfield);
        GuiNpcButton button = new GuiNpcButton(66, this.guiLeft + 107, this.guiTop + 8, 20, 20, "X");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (!this.field_146297_k.func_135016_M().func_135041_c().func_135034_a().equalsIgnoreCase("en_us")) {
            boolean kase = ("" + c).toLowerCase().equals("" + c);
            c = Keyboard.getKeyName((int)i).charAt(0);
            if (kase) {
                c = ("" + c).toLowerCase().charAt(0);
            }
        }
        String prev = this.textfield.func_146179_b();
        super.func_73869_a(c, i);
        String newText = this.textfield.func_146179_b();
        if (newText.equals(prev)) {
            return;
        }
        try {
            this.color = this.textfield.func_146179_b().isEmpty() ? 0 : Integer.parseInt(this.textfield.func_146179_b(), 16);
            this.callback.color(this.color);
        }
        catch (NumberFormatException e) {
            this.textfield.func_146180_a(prev);
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseBottom) {
        super.func_73864_a(mouseX, mouseY, mouseBottom);
        if (this.hovered && this.hover != 0) {
            this.color = this.hover;
            this.callback.color(this.hover);
            this.textfield.func_146180_a(this.getColor());
        }
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        try {
            this.color = Integer.parseInt(textfield.getFullText(), 16);
        }
        catch (NumberFormatException e) {
            this.color = 0;
        }
        this.callback.color(this.color);
    }

    public static interface ColorCallback {
        public void color(int var1);
    }
}

